from sendr_aiohttp.handler import request_schema, response_schema

from {{cookiecutter.import_path}}.api.handlers.base import BaseHandler
from {{cookiecutter.import_path}}.api.schemas.user import user_schema, user_uid_schema
from {{cookiecutter.import_path}}.core.actions.user import GetUserAction


class UserUIDHandler(BaseHandler):
    @request_schema(user_uid_schema, location='query')
    @response_schema(user_schema)
    async def get(self):
        data = await self.get_data()
        user = await self.run_action(GetUserAction, **data)
        return self.make_response(user)
